////////////////////////////////////////////////////////////////
// SurveyLoginPlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.SurveyLoginPlugin;


import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.PluginConstants;
import com.objectplanet.survey.plugin.interfaces.ISurveyLogin;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;


/**
 * This is a survey login example. This class will be called if the login for this plugin is enabled
 * in a survey. Any respondent for any survey needs to enter valid login name and password
 * (foo/bar) to start the survey.
 *
 * See ISurveyLogin for more info.
 *
 * @author Irina Brun
 */
public class SurveyLoginPlugin extends Plugin implements ISurveyLogin {

	private static final String	PARAMETER_NAME_PASSWORD	= "plugin_password";
	private static final String	PARAMETER_NAME_LOGIN	= "plugin_loginName";


	/**
	 * Gets the login screen for the survey. This example returns a simple login name/password
	 * screen. If login failes (checkLogin() returns false), then the same login screen will be
	 * displayed with the login name from the previous request and empty password.
	 *
	 * @param resources This HashMap contains both the HttpRequest and HttpResponse objects, if the
	 *            current survey is web based.
	 * @param surveyId Survey id
	 * @return The loginScreen coding.
	 */
	public String getLoginScreen(long surveyId, HashMap resources) {

		// Get the HTTP request and response
		HttpServletRequest request = (HttpServletRequest) resources.get(PluginConstants.RESOURCE_HTTP_REQUEST);

		// Get entered login name if the first login has failed
		String enteredLoginName = request.getParameter(PARAMETER_NAME_LOGIN);
		if (enteredLoginName == null) {
			enteredLoginName = "";
		}

		StringBuffer loginScreen = new StringBuffer();
		loginScreen.append("<table border=0 cellspacing=0>");

		loginScreen.append("<tr><td class=login colspan=2><br><br>");
		loginScreen.append("This is a survey login example.<br>");
		loginScreen.append("Valid login name and password to start the survey are <b>foo</b> and <b>bar</b>.<br><br>");
		loginScreen.append("</td>");

		// Add login name field. If login failed, the entered
		// login name will be used as default value for this field.
		loginScreen.append("<tr><td class=login width=\"15%\">");
		loginScreen.append("Login name:");
		loginScreen.append("</td>");

		loginScreen.append("<td class=login width=\"85%\">");
		loginScreen.append("<input type=text name=plugin_loginName value=\"");
		loginScreen.append(enteredLoginName);
		loginScreen.append("\">");
		loginScreen.append("	</td></tr>");

		// Add password field, no default value is set
		loginScreen.append("<tr><td class=login>");
		loginScreen.append("Password:");
		loginScreen.append("</td>");

		loginScreen.append("<td class=login>");
		loginScreen.append("<input type=password name=plugin_password>&nbsp;");

		// Login button
		loginScreen.append("<input type=submit name=plugin_loginButton value=Login>");
		loginScreen.append("</td></tr>");

		loginScreen.append("<tr><td class=login colspan=2 height=15></td></tr>");
		loginScreen.append("</table>");
		return loginScreen.toString();
	}


	/**
	 * Validates the login. Entered login name and password are stored in the HttpServletRequest
	 * object.
	 *
	 * @param surveyId Survey id
	 * @param resources This HashMap contains both the HttpRequest and HttpResponse objects, if the
	 *            current survey is web based.
	 * @return True if login OK, false otherwise (getLoginScreen() will be called)
	 */
	public boolean checkLogin(long surveyId, HashMap resources) {

		// Get the HTTP request and response
		HttpServletRequest request = (HttpServletRequest) resources.get(PluginConstants.RESOURCE_HTTP_REQUEST);

		// Get entered login name and password
		String enteredLoginName = request.getParameter(PARAMETER_NAME_LOGIN);
		String enteredPassword = request.getParameter(PARAMETER_NAME_PASSWORD);

		// If login name or password is empty, login fails
		if (enteredLoginName == null || enteredPassword == null) {
			return false;
		}

		// Compare entered login name and password with valid values
		// This is the place to insert code for database lookups, LDAP lookups, etc.
		if (enteredLoginName.equals("foo") && enteredPassword.equals("bar")) {
			return true;
		}
		return false;
	}
}
