////////////////////////////////////////////////////////////////
// SurveyFunctionExamplePlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.SurveyFunctionExamplePlugin;


import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.ProcessResult;
import com.objectplanet.survey.plugin.interfaces.menu.IPageActionSurvey;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;


/**
 * Implements the IPageActionSurvey Interface that makes it possible to hook plugin functions to the
 * survey admin screen. Menu items returned from this plugin will be added to the survey action
 * menu, and the plugin screen will appear when user clicks on the link. This plugin is also
 * responsible for processing the input values in the plugin html forms.
 *
 * The plugin example provides two simple functions: Recognize name and Recognize email address. The
 * plugin simple reports the value entered in the name/address field.
 *
 *
 * @author Irina Brun
 */
public class SurveyFunctionExamplePlugin extends Plugin implements IPageActionSurvey {

	/**
	 * The plugin provides two functions.
	 */
	public int getFunctionCount() {
		return 2;
	}


	/**
	 * Gets the SurveyMenuItem label. This will be shown in the survey admin menu. The plugin
	 * provides two functions. The label of the first function is "Recognize address", the second
	 * function label is "Recognize name"
	 *
	 * @param functionNo Function number
	 * @param resources This HashMap contains the HttpRequest and HttpResponse
	 *
	 * @return The label for the menu item
	 */
	public String getFunctionLabel(int functionNo, HashMap resources) {
		switch (functionNo) {
			case 1:
				return "Recognize address";
			case 2:
				return "Recognize name";
		}
		return "Unsupported function";
	}


	/**
	 * Gets html for a plugin function. This is only a very simple implementation of the
	 * getFunctionHTML() method. The parameter resources is not used in this example, but can be
	 * used to implement much more advanced and customized plugin function.
	 *
	 * @param functionNo Current function number
	 * @param resources This HashMap contains the HttpRequest and HttpResponse
	 * @return The html for a plugin funtion
	 */
	public String getFunctionHTML(int functionNo, HashMap resources) {
		StringBuffer pluginFunctionHTML = new StringBuffer();

		switch (functionNo) {
			case 1:
				pluginFunctionHTML.append("<table>");
				pluginFunctionHTML.append("	<tr><td class=\"form label\">Your mail address:</td>");
				pluginFunctionHTML.append("		<td class=\"form value\">");
				pluginFunctionHTML.append("			<INPUT TYPE=\"text\" class=width200 name=\"plugin_email\" value=\"\">");
				pluginFunctionHTML.append("		</td>");
				pluginFunctionHTML.append("	</tr>");
				pluginFunctionHTML.append("	<tr><td></td><td class=buttons>");
				pluginFunctionHTML.append("			<INPUT TYPE=submit class=button value=\"Ok\">");
				pluginFunctionHTML.append("		</td>");
				pluginFunctionHTML.append("	</tr>");
				pluginFunctionHTML.append("</table>");
				break;
			case 2:
				pluginFunctionHTML.append("<table>");
				pluginFunctionHTML.append("	<tr><td class=\"form label\">Name:</td>");
				pluginFunctionHTML.append("		<td class=\"form value\">");
				pluginFunctionHTML.append("			<INPUT TYPE=\"text\" class=width200 name=\"plugin_name\" value=\"\">");
				pluginFunctionHTML.append("		</td>");
				pluginFunctionHTML.append("	</tr>");
				pluginFunctionHTML.append("	<tr><td></td><td class=buttons>");
				pluginFunctionHTML.append("			<INPUT TYPE=submit class=button value=\"Ok\">");
				pluginFunctionHTML.append("		</td>");
				pluginFunctionHTML.append("	</tr>");
				pluginFunctionHTML.append("</table>");
				break;
		}

		return pluginFunctionHTML.toString();
	}


	/**
	 * Method for processing the plugin function html. This method is called when the plugin form is
	 * submitted.
	 *
	 * @param functionNo Current function number
	 * @param resources This HashMap contains the HttpRequest and HttpResponse
	 * @return The status message
	 */
	public ProcessResult processFunctionHTML(int functionNo, HashMap resources) {
		// retrieve request object
		HttpServletRequest request = (HttpServletRequest) resources.get("HttpRequest");

		// process the html based on function number
		switch (functionNo) {
			case 1:
				String email = request.getParameter("plugin_email");
				if (email == null || email.equals("")) {
					return new ProcessResult("Email cannot be blank!", true);
				}
				return new ProcessResult("Entered email is " + email, false);
			case 2:
				String name = request.getParameter("plugin_name");
				if (name == null || name.equals("")) {
					return new ProcessResult("Name cannot be blank!", true);
				}
				return new ProcessResult("Entered name is " + name, false);
		}
		return super.processFunctionHTML(functionNo, resources);
	}
}
