////////////////////////////////////////////////////////////////
// ReportPlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.ReportPlugin;


import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.interfaces.IReport;


/**
 * Implements report functionality.
 *
 * @author Irina Brun
 */
public class ReportPlugin extends Plugin implements IReport {

	/**
	 * Constructor for the ReportPlugin object
	 */
	public ReportPlugin() {
		super();
	}


	/**
	 * Gets the report name. This will be shown in the list of reports for a survey.
	 *
	 * @param surveyId Survey id
	 * @return The report name.
	 */
	public String getReportName(long surveyId) {
		return "My test report plugin";
	}


	/**
	 * Returns true if report exists for the survey
	 *
	 * @param surveyId Survey id
	 * @return True if the class implementing this interface produce report for the spesified survey
	 */
	public boolean availableForSurvey(long surveyId) {
		// available for all surveys!
		// if(surveyId == 2)
		return true;
		// return false;
	}


	/**
	 * Gets report html for a survey
	 *
	 * @param surveyId Survey id
	 * @return The report html
	 */
	public String getReportHTML(long surveyId) {
		StringBuffer reportHTML = new StringBuffer();
		reportHTML.append("<html><head></head><body>");
		reportHTML.append("<br><br><br>Hello! this is my first report plugin");
		reportHTML.append("</body></html>");
		return reportHTML.toString();
	}
}
