////////////////////////////////////////////////////////////////
// ReportElementPlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.ReportElementPlugin;


import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.interfaces.IReportElement;


/**
 * Implements report type functionality.
 *
 * @author Irina Brun
 */
public class ReportElementPlugin extends Plugin implements IReportElement {

	/**
	 * Constructor for the ReportPlugin object
	 */
	public ReportElementPlugin() {
		super();
	}


	/**
	 * Gets the report name. This will be shown in the list of reports for a survey.
	 *
	 * @param surveyId Survey id
	 * @return The report name.
	 */
	public String getElementType(long surveyId, long reportId) {
		return "My report type";
	}


	/**
	 * Returns true if report exists for the survey
	 *
	 * @param surveyId Survey id
	 * @return True if the class implementing this interface produce report for the spesified survey
	 */
	public boolean availableForReport(long surveyId, long reportId) {
		// available for all reports!
		return true;
	}


	/**
	 * Gets report html for a survey
	 *
	 * @param surveyId Survey id
	 * @return The report html
	 */
	public String getQuestionReportHTML(long surveyId, int questionNo, long reportId) {
		StringBuffer questionReportHTML = new StringBuffer();
		questionReportHTML.append("Hello world!");
		return questionReportHTML.toString();
	}
}
