////////////////////////////////////////////////////////////////
// LoginPlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.LoginPlugin;


import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.interfaces.ILogin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Implements login functionality. See ILogin for more details.
 *
 * In this example, the super user 'admin' will be automatically logged in. 
 * IMPORTANT: this is a dangerous plugin, and must never be put on a live production server.
 *
 * @author Irina Brun
 */
public class LoginPlugin extends Plugin implements ILogin {

	/**
	 * Constructor for the LoginPlugin object
	 */
	public LoginPlugin() {
		super();
	}


	/**
	 * Gets id of the user to login to the system. If <code>isLoginVisible()</code> returns true,
	 * the login screen will be shown to the user. When the user clicks the "Login" button, this
	 * method will be called with login name and password as parameters.
	 *
	 * @param loginName Login name entered (if login screen is visible) or null.
	 * @param password Password entered (if login screen is visible) or null.
	 * @return Returns id of the user registered in the survey system. If the user does not exist,
	 *         the login screen will be shown with an error message.
	 */
	public long getUserId(String loginName, String password) {
		// Place the login code here and return user id

		// This example returns id of the super user.
		// WARNING: anyone who accesses Opinio will be logged in as 'admin'.
		return 1;
	}


	/**
	 * True if login screen is visible to the user.
	 *
	 * @return The loginVisible value
	 */
	public boolean isLoginVisible() {
		return false;
	}


	/**
	 * Sets the response object. This method will be called before calling <code>getUserId()</code>.
	 *
	 * @param response The response
	 */
	public void setResponse(HttpServletResponse response) {
	}


	/**
	 * Sets the request object. This method will be called before calling <code>getUserId()</code>.
	 *
	 * @param request The request
	 */
	public void setRequest(HttpServletRequest request) {
	}
}
