////////////////////////////////////////////////////////////////
// DisplaySurveySaveScreenSamplePlugin.java
//
// Copyright (C) ObjectPlanet, Inc.
// All rights reserved.
// Confidential, unpublished property of ObjectPlanet, Inc.
////////////////////////////////////////////////////////////////

package com.objectplanet.plugin.survey.DisplaySurveySaveScreenSamplePlugin;


import com.objectplanet.survey.event.Event;
import com.objectplanet.survey.event.EventBusManager;
import com.objectplanet.survey.event.IEventListener;
import com.objectplanet.survey.event.events.DisplaySurveySaveScreenEvent;
import com.objectplanet.survey.plugin.Plugin;
import com.objectplanet.survey.plugin.api.PluginUtil;


/**
 * This is a sample plugin for demonstrating how a custom message can be set on the survey save screen.
 *
 * @author Torgeir Lund, Eivind Pedersen
 * @created November 20, 2008
 */
public class DisplaySurveySaveScreenSamplePlugin extends Plugin implements IEventListener {
	
	/**
	 * Constructor for the DisplaySurveySaveScreenSamplePlugin object
	 */
	public DisplaySurveySaveScreenSamplePlugin() {
		super();
	}


	/**
	 * Returns help html
	 *
	 * @see Plugin#getHelpHTML()
	 */
	public String getHelpHTML() {
		return "Sample plugin.";
	}


	/**
	 * Handles the events that this plugin is registered to receive.
	 *
	 * @see IEventListener#handleEvent(Event)
	 * @param event The event.
	 */
	public void handleEvent(Event event) {

		if (event instanceof DisplaySurveySaveScreenEvent) {
			((DisplaySurveySaveScreenEvent) event).setSaveScreenContent("This is the save screen from the DisplaySurveySaveScreenSamplePlugin.");
		}
	}


	/**
	 * Starts the plugin. The survey event bus registrations are made here.
	 *
	 * @see Plugin#start()
	 */
	public void start() {
		// register the listeners
		EventBusManager eventMgr = EventBusManager.instance();
		eventMgr.addListener(this, EventBusManager.BUS_TYPE_SURVEY, EventBusManager.EVENT_TYPE_DISPLAY_SURVEY_SAVE_SCREEN);

		// log the plugin status
		PluginUtil.info("DisplaySurveySaveScreenSamplePlugin loaded");
	}
}
